<?php

/**
 * Point Requirements Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Journals extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Jurnal';

		$this->twiggy_display('adm/journals/index', $data);
	}

	public function get_data_header()
	{
		$data = [];

		$get_data = $this->Journals_model->journal_header()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->journal_header_id,
					'number'      => $get_row->journal_header_number,
					'date'        => indonesian_date($get_row->journal_header_date),
					'description' => $get_row->journal_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Jurnal";
		$header_data = array(null);

		$number  = '';
		$description  = '';

		if ($id != 'new') {
			$title       = "Edit Jurnal";
			$where       = array('journal_header_id' => $id);
			$header_data = $this->Journals_model->journal_header($where)->row_array();
			$number      = $header_data['journal_header_number'];
			// $start_date  = $header_data['journal_header_period_start'];
			// $end_date    = $header_data['journal_header_period_end'];
			// $total_point = $header_data['journal_header_total'];
			$description  = $header_data['journal_header_description'];
		}

		$data['id']            = $id;
		$data['number']        = $number;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['description']   = $description;

		$this->twiggy_display('adm/journals/edit', $data);
	}

	public function get_data_detail()
	{
		$id    = $this->input->post("id");
		$where = array('journal_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Journals_model->journal_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->journal_detail_id,
					'detail_header_id' => $get_row->journal_detail_header_id,
					'type_name'       => $get_row->account_type_name,
					'id'               => $get_row->journal_detail_account_id,
					'number'           => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
					'name'             => $get_row->account_name,
					'debit'            => number_format($get_row->journal_detail_debit),
					'credit'           => number_format($get_row->journal_detail_credit),
					'description'      => $get_row->journal_detail_description
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Akun';
		$this->twiggy_display('adm/journals/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Accounts_model->get_data_search($search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$data[] = array(
				'no'              => $no,
				'id'              => $get_row->account_id,
				'name'            => $get_row->account_name,
				'number'          => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
				'type_name'       => $get_row->account_type_name,
				'normal_balance'  => $get_row->normal_balance,
				'opening_balance' => number_format($get_row->opening_balance),
				'debit'           => 0,
				'credit'          => 0,
				'btncolor'        => '',
				'btnicon'         => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id           = $this->input->post('id');
		$number       = $this->input->post('number');
		$total_debit  = $this->input->post("total_debit");
		$total_credit = $this->input->post("total_credit");
		$description  = $this->input->post("description");

		$vuedata = $this->input->post('vuedata');

		$header_id   = $id;

		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_date'         => date_now(),
			'journal_header_total_debit'  => trims($total_debit),
			'journal_header_total_credit' => trims($total_credit),
			'journal_header_description'  => $description,
		];

		$detail_data = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Journals_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'journal_detail_header_id'      => $header_id,
						'journal_detail_account_id'     => $row['id'],
						'journal_detail_account_number' => $row['number'],
						'journal_detail_account_name'   => $row['name'],
						'journal_detail_debit'          => trims($row['debit']),
						'journal_detail_credit'         => trims($row['credit']),
						'journal_detail_description'    => $row['description']
					];
				}

				$save_detail = $this->Journals_model->save_detail($detail_data, true);

				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			$delete_detail = $this->Journals_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Journals_model->update_header($id, $header_data);

				if ($save_header) {
					// $header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'journal_detail_header_id'      => $header_id,
							'journal_detail_account_id'     => $row['id'],
							'journal_detail_account_number' => $row['number'],
							'journal_detail_account_name'   => $row['name'],
							'journal_detail_debit'          => trims($row['debit']),
							'journal_detail_credit'         => trims($row['credit']),
							'journal_detail_description'    => $row['description']
						];
					}

					$save_detail = $this->Journals_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$delete_header = $this->Journals_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Journals_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('journal_header_id' => $id);
		$where_detail = array('journal_detail_header_id' => $id);

		$header = $this->Journals_model->journal_header($where_header)->row_array();
		$detail = $this->Journals_model->journal_detail($where_detail)->result();

		$data['content_title'] = 'Print Ketentuan Poin';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/journals/print_out', $data);
	}
}
